package gov.va.vinci.dart.json.builder;

import java.text.SimpleDateFormat;

import gov.va.vinci.dart.biz.RequestLocationDocumentSummary;
import gov.va.vinci.dart.biz.RequestParticipantDocumentSummary;
import gov.va.vinci.dart.json.DocumentView;

public class DocumentViewBuilder {
	public static final SimpleDateFormat SDF = new SimpleDateFormat("MM/dd/yyyy");
	public static final SimpleDateFormat LONG_FORMAT_SDF = new SimpleDateFormat("MM/dd/yy hh:mmaa");

	public DocumentView build(final RequestLocationDocumentSummary summary) {

		DocumentView result = new DocumentView();
		result.setId(summary.getDocumentId());
		result.setName(summary.getDocumentName());
		result.setDescription(summary.getDescription());
		result.setHeadId(summary.getHeadId());
		result.setVersionNumber(summary.getVersionNumber());
		result.setSortOrder(summary.getSortOrder());
		result.setDocType("File Document");
		
		result.setCreatedBy(summary.getCreatedBy());
		result.setCreatedOn(SDF.format(summary.getCreatedOn()));
		result.setUpdatedBy(summary.getUpdatedBy());
		result.setUpdatedOn(summary.getUpdatedOn()==null?"":LONG_FORMAT_SDF.format(summary.getUpdatedOn()));
		if (summary.getUpdatedOn() != null) {
			result.setUploaded(true);
		}

		result.setReviewStatus(summary.getReviewStatus());

		return result;
	}
	
	public DocumentView build(final RequestParticipantDocumentSummary summary) {

		DocumentView result = new DocumentView();
		result.setId(summary.getDocumentId());
		result.setName(summary.getDocumentName());
		result.setDescription(summary.getDescription());
		result.setHeadId(summary.getHeadId());
		result.setVersionNumber(summary.getVersionNumber());
		result.setSortOrder(summary.getSortOrder());
		result.setDocType("File Document");
		
		result.setCreatedBy(summary.getCreatedBy());
		result.setCreatedOn(SDF.format(summary.getCreatedOn()));
		result.setUpdatedBy(summary.getUpdatedBy());
		result.setUpdatedOn(summary.getUpdatedOn()==null?"":LONG_FORMAT_SDF.format(summary.getUpdatedOn()));
		if (summary.getUpdatedOn() != null) {
			result.setUploaded(true);
		}

		result.setReviewStatus(summary.getReviewStatus());

		return result;
	}

}
